<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name', 'Medex')); ?> - Legal & Financial Consultation Platform</title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #1e3a8a 0%, #3730a3 50%, #1e40af 100%);
        }
        
        .hero-pattern {
            background-image: 
                radial-gradient(circle at 25% 25%, rgba(255,255,255,0.1) 0%, transparent 50%),
                radial-gradient(circle at 75% 75%, rgba(255,255,255,0.05) 0%, transparent 50%),
                linear-gradient(45deg, transparent 30%, rgba(255,255,255,0.03) 70%);
        }
        
        .glass-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .hover-scale {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        
        .hover-scale:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .step-number {
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
            background-size: 200% 200%;
            animation: gradient 3s ease infinite;
        }
        
        @keyframes gradient {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        .professional-card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 16px;
            padding: 2rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        .professional-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            background: rgba(255, 255, 255, 1);
        }
        
        .feature-item {
            transition: all 0.3s ease;
            padding: 1rem;
            border-radius: 12px;
        }
        
        .feature-item:hover {
            background: rgba(59, 130, 246, 0.05);
            transform: translateX(5px);
        }
        
        .hover-scale {
            transition: all 0.3s ease;
        }
        
        .hover-scale:hover {
            transform: scale(1.05);
        }
            font-size: 1.2rem;
            opacity: 0.9;
            margin-bottom: 2rem;
        }
        
        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
            margin-bottom: 3rem;
        }
        
        .feature-card {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            padding: 2rem;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .feature-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 1rem;
        }
        
        .feature-desc {
            opacity: 0.9;
            line-height: 1.6;
        }
        
        .cta-section {
            margin-top: 3rem;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 30px;
            margin: 0 10px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        
        .btn-primary {
            background: white;
            color: #667eea;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .btn-secondary {
            background: transparent;
            color: white;
            border-color: white;
        }
        
        .btn-secondary:hover {
            background: white;
            color: #667eea;
        }
        
        .nav {
            position: absolute;
            top: 2rem;
            right: 2rem;
        }
        
        .nav a {
            color: white;
            text-decoration: none;
            margin: 0 1rem;
            opacity: 0.9;
            transition: opacity 0.3s ease;
        }
        
        .hero-clean {
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            position: relative;
        }
        
        .floating-element {
            position: absolute;
            border-radius: 50%;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        .float-animation {
            animation: float 3s ease-in-out infinite;
        }
        
    </style>
</head>

<body class="bg-white">
    <!-- Header Component -->
    <?php echo $__env->make('components.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Hero Section -->
    <section class="bg-gradient-to-br from-blue-900 via-blue-800 to-indigo-900 text-white py-24 relative overflow-hidden">
        <!-- Subtle Background Pattern -->
        <div class="absolute inset-0 opacity-10">
            <div class="absolute inset-0" style="background-image: 
                radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%), 
                radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(120, 219, 226, 0.3) 0%, transparent 50%);"></div>
        </div>
        
        <!-- Floating Elements -->
        <div class="absolute top-20 left-10 w-2 h-2 bg-purple-400 rounded-full float-animation" style="animation-delay: 0s;"></div>
        <div class="absolute top-32 right-20 w-3 h-3 bg-pink-400 rounded-full float-animation" style="animation-delay: 1s;"></div>
        <div class="absolute bottom-32 left-20 w-2 h-2 bg-cyan-400 rounded-full float-animation" style="animation-delay: 2s;"></div>
        <div class="absolute top-40 right-40 w-1 h-1 bg-indigo-300 rounded-full float-animation" style="animation-delay: 3s;"></div>
        <div class="absolute bottom-20 right-10 w-2 h-2 bg-rose-300 rounded-full float-animation" style="animation-delay: 4s;"></div>
        
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            <div class="grid lg:grid-cols-12 gap-12 items-center">
                <!-- Left Content - 7 columns -->
                <div class="lg:col-span-7 text-left">
                    <div class="inline-flex items-center px-4 py-2 rounded-full bg-white/10 backdrop-blur-sm border border-white/20 text-sm font-medium mb-6 text-blue-200">
                        🚀 Trusted by 5+ Lakh Professionals
                    </div>
                    <h1 class="text-5xl md:text-6xl lg:text-7xl font-bold mb-6 leading-tight">
                        <span class="bg-gradient-to-r from-yellow-300 to-orange-400 bg-clip-text text-transparent block">
                            Passion
                        </span>
                        <span class="bg-gradient-to-r from-blue-300 to-purple-300 bg-clip-text text-transparent block">
                            Smarter
                        </span>
                        <span class="bg-gradient-to-r from-green-300 to-teal-300 bg-clip-text text-transparent block">
                            MEDEX
                        </span>
                    </h1>
                    <p class="text-xl text-blue-100 mb-8 leading-relaxed max-w-xl">
                        Complete legal, financial & compliance solutions for healthcare professionals. 
                        Connect with verified Advocates, CAs, CSs & CMAs instantly.
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4 mb-12">
                        <a href="<?php echo e(route('register')); ?>" 
                           class="bg-white text-blue-900 px-8 py-4 rounded-xl font-semibold text-lg hover:bg-blue-50 transition-all transform hover:scale-105 shadow-lg">
                            Start Free Consultation
                        </a>
                        <a href="#how-it-works" 
                           class="bg-white/10 backdrop-blur-sm border border-white/20 text-white px-8 py-4 rounded-xl font-semibold text-lg hover:bg-white/20 transition-all">
                            See How It Works
                        </a>
                    </div>
                </div>
                
                <!-- Right Content - 5 columns -->
                <div class="lg:col-span-5 relative">
                    <div class="bg-white/10 backdrop-blur-lg rounded-2xl border border-white/20 p-8 mb-6 shadow-2xl">
                        <div class="flex items-center gap-3 mb-4">
                            <div class="w-3 h-3 bg-red-400 rounded-full"></div>
                            <div class="w-3 h-3 bg-yellow-400 rounded-full"></div>
                            <div class="w-3 h-3 bg-green-400 rounded-full"></div>
                        </div>
                        <div class="bg-white/20 backdrop-blur-sm rounded-lg p-6 border border-white/30">
                            <div class="text-sm text-blue-200 mb-2 font-medium">Professional Dashboard</div>
                            <div class="text-lg font-semibold text-white">Dr. Priya Sharma - Consultation</div>
                            <div class="text-sm text-blue-300 mt-2">Legal Advisory • Tax Planning • Compliance</div>
                            <div class="flex gap-2 mt-4">
                                <span class="px-3 py-1 bg-green-400/20 text-green-300 rounded-full text-xs font-medium">Verified ✓</span>
                                <span class="px-3 py-1 bg-blue-400/20 text-blue-300 rounded-full text-xs font-medium">Available</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Stats -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 mt-20">
                <div class="bg-white/10 backdrop-blur-sm rounded-xl shadow-lg p-6 text-center hover:bg-white/20 transition-all border border-white/20">
                    <div class="text-3xl font-bold text-white">500,000+</div>
                    <div class="text-blue-200 text-sm font-medium">Cases Resolved</div>
                </div>
                <div class="bg-white/10 backdrop-blur-sm rounded-xl shadow-lg p-6 text-center hover:bg-white/20 transition-all border border-white/20">
                    <div class="text-3xl font-bold text-white">1000+</div>
                    <div class="text-blue-200 text-sm font-medium">Expert Professionals</div>
                </div>
                <div class="bg-white/10 backdrop-blur-sm rounded-xl shadow-lg p-6 text-center hover:bg-white/20 transition-all border border-white/20">
                    <div class="text-3xl font-bold text-white">50+</div>
                    <div class="text-blue-200 text-sm font-medium">Specializations</div>
                </div>
                <div class="bg-white/10 backdrop-blur-sm rounded-xl shadow-lg p-6 text-center hover:bg-white/20 transition-all border border-white/20">
                    <div class="text-3xl font-bold text-white">24/7</div>
                    <div class="text-blue-200 text-sm font-medium">Support Available</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Expert Lawyers Section -->
    <section class="py-20 bg-gradient-to-br from-gray-50 to-blue-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">
                    Meet Our Expert Professionals
                </h2>
                <p class="text-xl text-gray-600">Connecting healthcare professionals with verified experts across India</p>
            </div>
                <p class="text-lg text-gray-600 max-w-2xl mx-auto">
                    Our verified professionals include Advocates, Chartered Accountants, Company Secretaries, and Certified Management Accountants
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <!-- Advocate -->
                <div class="bg-white border border-gray-200 p-6 rounded-lg shadow-sm">
                    <div class="flex gap-3 items-center mb-4">
                        <img src="https://ui-avatars.com/api/?name=Advocate+Sharma&background=022B50&color=ffffff&size=60&rounded=true" 
                             alt="Advocate Sharma" class="w-15 h-15 rounded-full">
                        <div>
                            <h3 class="font-semibold text-lg text-gray-900">Adv. Rajesh Sharma</h3>
                            <p class="text-sm text-gray-600">Advocate | 8 years experience</p>
                        </div>
                    </div>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li>• Specializes in Corporate Law & Contract Drafting</li>
                        <li>• Expert in Legal Notices & Litigation</li>
                        <li>• Property Law & Employment Issues</li>
                    </ul>
                </div>

                <!-- Chartered Accountant -->
                <div class="bg-white border border-gray-200 p-6 rounded-lg shadow-sm">
                    <div class="flex gap-3 items-center mb-4">
                        <img src="https://ui-avatars.com/api/?name=CA+Priya&background=022B50&color=ffffff&size=60&rounded=true" 
                             alt="CA Priya" class="w-15 h-15 rounded-full">
                        <div>
                            <h3 class="font-semibold text-lg text-gray-900">CA Priya Mehta</h3>
                            <p class="text-sm text-gray-600">Chartered Accountant | 6 years experience</p>
                        </div>
                    </div>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li>• Tax Planning & GST Compliance</li>
                        <li>• Financial Audit & Accounting</li>
                        <li>• Business Valuation & Investment Advisory</li>
                    </ul>
                </div>

                <!-- Company Secretary -->
                <div class="bg-white border border-gray-200 p-6 rounded-lg shadow-sm">
                    <div class="flex gap-3 items-center mb-4">
                        <img src="https://ui-avatars.com/api/?name=CS+Kumar&background=022B50&color=ffffff&size=60&rounded=true" 
                             alt="CS Kumar" class="w-15 h-15 rounded-full">
                        <div>
                            <h3 class="font-semibold text-lg text-gray-900">CS Amit Kumar</h3>
                            <p class="text-sm text-gray-600">Company Secretary | 7 years experience</p>
                        </div>
                    </div>
                    <ul class="space-y-2 text-sm text-gray-600">
                        <li>• Corporate Compliance & Governance</li>
                        <li>• Company Registration & ROC Filings</li>
                        <li>• Board Meetings & Secretarial Audit</li>
                    </ul>
                </div>

                <!-- CMA -->
                <div class="bg-white border border-gray-100 p-8 rounded-xl shadow-lg hover:shadow-xl transition-all transform hover:-translate-y-1">
                    <div class="flex gap-4 items-center mb-6">
                        <div class="w-16 h-16 bg-gradient-to-r from-orange-500 to-red-600 rounded-full flex items-center justify-center">
                            <span class="text-white font-bold text-xl">CM</span>
                        </div>
                        <div>
                            <h3 class="font-bold text-xl text-gray-900">CMA Ravi Singh</h3>
                            <p class="text-gray-600 font-medium">Certified Management Accountant • 5 years</p>
                        </div>
                    </div>
                    <ul class="space-y-3 text-gray-700">
                        <li class="flex items-center">
                            <span class="w-2 h-2 bg-orange-500 rounded-full mr-3"></span>
                            Cost Management & Budget Planning
                        </li>
                        <li class="flex items-center">
                            <span class="w-2 h-2 bg-orange-500 rounded-full mr-3"></span>
                            Financial Planning & Analysis
                        </li>
                        <li class="flex items-center">
                            <span class="w-2 h-2 bg-orange-500 rounded-full mr-3"></span>
                            Performance Management & MIS
                        </li>
                    </ul>
                </div>
            </div>

            
        </div>
    </section>

    <!-- Services Section -->
    <section id="section1" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">
                    Our Professional Areas of Expertise
                </h2>
                <p class="text-xl text-gray-600">Comprehensive solutions for all your professional needs</p>
            </div>

            <div class="flex flex-col lg:flex-row gap-12">
                <!-- Services List -->
                <div class="lg:w-1/3">
                    <div class="bg-white border border-blue-200 rounded-2xl p-4 shadow-lg max-h-96 overflow-y-auto">
                        <div class="space-y-3" id="services-list">
                            <div class="py-4 px-6 cursor-pointer bg-gradient-to-r from-blue-600 to-blue-700 text-white rounded-xl service-item active shadow-md" data-service="legal-services">
                                <h3 class="text-lg font-semibold">Legal Services (Advocates)</h3>
                            </div>
                            <div class="py-4 px-6 cursor-pointer hover:bg-blue-50 rounded-xl transition-all service-item" data-service="ca-services">
                                <h3 class="text-lg font-medium text-gray-700">CA Services</h3>
                            </div>
                            <div class="py-4 px-6 cursor-pointer hover:bg-blue-50 rounded-xl transition-all service-item" data-service="cs-services">
                                <h3 class="text-lg font-medium text-gray-700">Company Secretary Services</h3>
                            </div>
                            <div class="py-4 px-6 cursor-pointer hover:bg-blue-50 rounded-xl transition-all service-item" data-service="cma-services">
                                <h3 class="text-lg font-medium text-gray-700">CMA Services</h3>
                            </div>
                            <div class="py-4 px-6 cursor-pointer hover:bg-blue-50 rounded-xl transition-all service-item" data-service="legal-notices">
                                <h3 class="text-lg font-medium">Legal Notices</h3>
                            </div>
                            <div class="py-4 px-4 cursor-pointer hover:bg-gray-50 service-item" data-service="tax-gst">
                                <h3 class="text-lg font-medium">Tax & GST Compliance</h3>
                            </div>
                            <div class="py-4 px-4 cursor-pointer hover:bg-gray-50 service-item" data-service="corporate-compliance">
                                <h3 class="text-lg font-medium">Corporate Compliance</h3>
                            </div>
                            <div class="py-4 px-4 cursor-pointer hover:bg-gray-50 service-item" data-service="financial-planning">
                                <h3 class="text-lg font-medium">Financial Planning</h3>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Service Details -->
                <div class="lg:w-2/3">
                    <div id="service-details">
                        <!-- Legal Services -->
                        <div id="legal-services" class="service-content">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">👨‍⚖️ ADVOCATE (LAWYER) SERVICES</h3>
                            
                            <div class="space-y-6">
                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Legal Advisory Services</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Criminal & Civil case consultation</li>
                                        <li>• Medical negligence cases (doctor–patient disputes)</li>
                                        <li>• Consumer court matters against hospitals/clinics</li>
                                        <li>• Legal notices drafting</li>
                                        <li>• FIR / Police case guidance</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Documentation & Drafting</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Agreements & Contracts (employment, partnership, rent)</li>
                                        <li>• Affidavits, Declarations, Undertakings</li>
                                        <li>• Legal opinion drafting</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Business & Compliance Legal Services</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Medical clinic registration legal support</li>
                                        <li>• Healthcare business compliance (MTP, PCPNDT, Bio-medical waste rules)</li>
                                        <li>• Vendor contract review for medical stores & clinics</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Regulatory Advisory</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Licensing issues</li>
                                        <li>• Legal compliance for pharmacies</li>
                                        <li>• Hospital SOP & legal compliance guidance</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- CA Services -->
                        <div id="ca-services" class="service-content hidden">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">💼 CA – CHARTERED ACCOUNTANT SERVICES</h3>
                            
                            <div class="space-y-6">
                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Taxation Services</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Income Tax consultation</li>
                                        <li>• GST registration, filing & advisory</li>
                                        <li>• TDS filing & corrections</li>
                                        <li>• Advance tax & capital gain queries (for doctors/medical businesses)</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Accounting & Financial Management</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Bookkeeping for clinics, pharmacies, labs</li>
                                        <li>• Profit & loss analysis</li>
                                        <li>• Medical business financial planning</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Registrations</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Proprietorship / Partnership registration</li>
                                        <li>• MSME registration</li>
                                        <li>• GST registration</li>
                                        <li>• PAN/TAN services</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Audit Services</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Clinic/hospital audit</li>
                                        <li>• Pharmacy audit</li>
                                        <li>• Internal/Statutory audit guidance</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- CS Services -->
                        <div id="cs-services" class="service-content hidden">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">🧾 CS – COMPANY SECRETARY SERVICES</h3>
                            
                            <div class="space-y-6">
                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Corporate Compliance</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Company incorporation (Pvt Ltd, LLP, OPC)</li>
                                        <li>• ROC filings (MCA compliance)</li>
                                        <li>• Annual returns & board resolutions</li>
                                        <li>• Maintaining statutory registers</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Corporate Law Advisory</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Compliance for hospitals/medical companies</li>
                                        <li>• Legal documentation review for corporate medical entities</li>
                                        <li>• CSR compliance (if applicable)</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Secretarial Records</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Minutes preparation</li>
                                        <li>• Share allotment & transfer</li>
                                        <li>• Director KYC (DIR-3/KYC)</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Policy & Governance</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Drafting company policies</li>
                                        <li>• Corporate governance support</li>
                                        <li>• FEMA/RBI compliance</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- CMA Services -->
                        <div id="cma-services" class="service-content hidden">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">📊 CMA – COST & MANAGEMENT ACCOUNTANT SERVICES</h3>
                            
                            <div class="space-y-6">
                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Cost Consultancy</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Clinic/hospital cost analysis</li>
                                        <li>• Pharmacy pricing strategy</li>
                                        <li>• Cost reduction planning</li>
                                        <li>• Inventory cost management</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Financial Planning</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Budgeting for medical businesses</li>
                                        <li>• Cash-flow forecasting</li>
                                        <li>• Financial performance reports</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Audit & Compliance</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Cost audit support</li>
                                        <li>• GST audit assistance</li>
                                        <li>• Internal audit planning</li>
                                    </ul>
                                </div>

                                <div>
                                    <h4 class="font-semibold text-lg text-gray-800 mb-3">Business Advisory</h4>
                                    <ul class="space-y-2 text-gray-600">
                                        <li>• Break-even analysis for clinics</li>
                                        <li>• Loans & funding documentation assistance</li>
                                        <li>• Pricing models for services & medicine retail</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Service Categories -->
                        <div id="legal-notices" class="service-content hidden">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">Legal Notices & Documentation</h3>
                            <p class="text-gray-600 mb-4">
                                Specialized legal notice drafting and documentation services for healthcare professionals.
                            </p>
                            <ul class="space-y-2 text-gray-600">
                                <li>• Medical negligence legal notices</li>
                                <li>• Recovery notices for outstanding dues</li>
                                <li>• Contract breach notices</li>
                                <li>• Employment termination notices</li>
                                <li>• Consumer complaint documentation</li>
                            </ul>
                        </div>

                        <div id="tax-gst" class="service-content hidden">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">Tax & GST Compliance</h3>
                            <p class="text-gray-600 mb-4">
                                Comprehensive taxation support for medical businesses and healthcare professionals.
                            </p>
                            <ul class="space-y-2 text-gray-600">
                                <li>• Medical practice income tax planning</li>
                                <li>• GST for healthcare services</li>
                                <li>• Pharmacy GST compliance</li>
                                <li>• Diagnostic lab taxation</li>
                                <li>• Hospital tax advisory</li>
                            </ul>
                        </div>

                        <div id="corporate-compliance" class="service-content hidden">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">Corporate Compliance</h3>
                            <p class="text-gray-600 mb-4">
                                Complete corporate compliance solutions for medical companies and healthcare organizations.
                            </p>
                            <ul class="space-y-2 text-gray-600">
                                <li>• Hospital company incorporation</li>
                                <li>• Medical device company compliance</li>
                                <li>• Pharma distribution company setup</li>
                                <li>• Healthcare startup legal structure</li>
                                <li>• Medical chain expansion compliance</li>
                            </ul>
                        </div>

                        <div id="financial-planning" class="service-content hidden">
                            <h3 class="text-xl font-bold text-[#022B50] mb-4">Financial Planning & Analysis</h3>
                            <p class="text-gray-600 mb-4">
                                Strategic financial planning and cost management for healthcare businesses.
                            </p>
                            <ul class="space-y-2 text-gray-600">
                                <li>• Clinic expansion financial planning</li>
                                <li>• Medical equipment financing</li>
                                <li>• Pharmacy inventory management</li>
                                <li>• Hospital cost optimization</li>
                                <li>• Healthcare investment advisory</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Online Consultation Section -->
    <section id="section2" class="py-20 bg-gradient-to-br from-gray-50 to-blue-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-12">
                <h2 class="text-4xl font-bold text-gray-900 mb-6">
                    Professional Consultation Services
                </h2>
                <p class="text-xl text-gray-600 max-w-4xl mx-auto">
                    Connect with verified experts and get professional guidance tailored to your business needs
                </p>
            </div>
            
            <div class="grid md:grid-cols-3 gap-8 mb-12">
                <div class="bg-white p-8 rounded-xl shadow-lg text-center">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Verified Experts</h3>
                    <p class="text-gray-600">All professionals are verified and have proven track records in their respective fields</p>
                </div>
                
                <div class="bg-white p-8 rounded-xl shadow-lg text-center">
                    <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Flexible Scheduling</h3>
                    <p class="text-gray-600">Book consultations at your convenience with flexible timing options</p>
                </div>
                
                <div class="bg-white p-8 rounded-xl shadow-lg text-center">
                    <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-gray-900 mb-3">Multiple Consultation Modes</h3>
                    <p class="text-gray-600">Choose from video calls, audio consultations, or chat sessions</p>
                </div>
            </div>
            
            <div class="bg-white p-8 rounded-2xl shadow-lg">
                <div class="text-lg text-gray-700 space-y-6 leading-relaxed">
                    <p>
                        Getting reliable professional help is now easier with our online consultation platform. 
                        Whether you need legal advice from Advocates, financial guidance from Chartered Accountants, 
                        corporate compliance support from Company Secretaries, or cost management advice from CMAs, 
                        our platform connects you with verified professionals.
                    </p>
                    <p>
                        With Medex, you can choose from experts across different domains - legal, taxation, corporate affairs, 
                        and financial management. Get personalized, professional advice tailored to your business needs 
                        from qualified Advocates, CAs, CSs, and CMAs—all from the comfort of your office or home.
                    </p>
                    <p>
                        Our consultation service allows you to schedule sessions at your convenience, simplifying 
                        the process of obtaining expert professional assistance. Whether it's legal documentation, 
                        tax planning, corporate filings, or financial analysis, our verified professionals are here to help.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- How It Works Section -->
    <section id="how-it-works" class="py-24 bg-gradient-to-br from-gray-50 to-blue-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <div class="inline-flex items-center px-4 py-2 rounded-full bg-blue-100 text-blue-800 text-sm font-medium mb-4">
                    From Startup to Scale-Up - We Power Your Growth
                </div>
                <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-6">
                    How It Works
                </h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    Get expert professional guidance in 4 simple steps. Our streamlined process ensures you get the right expertise exactly when you need it.
                </p>
            </div>
            
            <div class="grid lg:grid-cols-2 gap-16 items-center">
                <div class="space-y-8">
                    <div class="flex gap-6">
                        <div class="step-number w-12 h-12 rounded-full flex items-center justify-center text-white font-bold text-lg flex-shrink-0">
                            1
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900 mb-2">Tell Us Your Requirement</h3>
                            <p class="text-gray-600">Share your business challenge - legal, financial, compliance or strategic. Our AI matches you with the right professional.</p>
                        </div>
                    </div>
                    
                    <div class="flex gap-6">
                        <div class="step-number w-12 h-12 rounded-full flex items-center justify-center text-white font-bold text-lg flex-shrink-0">
                            2
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900 mb-2">Connect with Experts</h3>
                            <p class="text-gray-600">Choose from verified Advocates, CAs, CSs & CMAs. View profiles, specializations, and ratings before booking.</p>
                        </div>
                    </div>
                    
                    <div class="flex gap-6">
                        <div class="step-number w-12 h-12 rounded-full flex items-center justify-center text-white font-bold text-lg flex-shrink-0">
                            3
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900 mb-2">Schedule & Pay Securely</h3>
                            <p class="text-gray-600">Book your preferred time slot with transparent pricing. Secure payment with multiple options including EMI.</p>
                        </div>
                    </div>
                    
                    <div class="flex gap-6">
                        <div class="step-number w-12 h-12 rounded-full flex items-center justify-center text-white font-bold text-lg flex-shrink-0">
                            4
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-gray-900 mb-2">Get Results & Ongoing Support</h3>
                            <p class="text-gray-600">Receive expert consultation with actionable solutions. Get follow-up support and documentation as needed.</p>
                        </div>
                    </div>
                </div>
                
                <div class="relative">
                    <div class="bg-white rounded-3xl shadow-2xl p-8">
                        <div class="flex items-center justify-between mb-6">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 bg-blue-600 rounded-lg flex items-center justify-center">
                                    <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                </div>
                                <span class="font-semibold text-gray-900">Your Business Dashboard</span>
                            </div>
                            <div class="text-sm text-gray-500">Live</div>
                        </div>
                        
                        <div class="space-y-4">
                            <div class="flex items-center justify-between p-4 bg-green-50 rounded-lg border border-green-200">
                                <div class="flex items-center gap-3">
                                    <div class="w-2 h-2 bg-green-500 rounded-full"></div>
                                    <span class="text-sm font-medium">CA Consultation - Tax Planning</span>
                                </div>
                                <span class="text-xs text-green-600 font-medium">Completed</span>
                            </div>
                            
                            <div class="flex items-center justify-between p-4 bg-blue-50 rounded-lg border border-blue-200">
                                <div class="flex items-center gap-3">
                                    <div class="w-2 h-2 bg-blue-500 rounded-full animate-pulse"></div>
                                    <span class="text-sm font-medium">Legal Review - Contract Drafting</span>
                                </div>
                                <span class="text-xs text-blue-600 font-medium">In Progress</span>
                            </div>
                            
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg border border-gray-200">
                                <div class="flex items-center gap-3">
                                    <div class="w-2 h-2 bg-gray-400 rounded-full"></div>
                                    <span class="text-sm font-medium">CS Service - ROC Filing</span>
                                </div>
                                <span class="text-xs text-gray-600 font-medium">Scheduled</span>
                            </div>
                        </div>
                        
                        <div class="mt-6 p-4 bg-gradient-to-r from-purple-50 to-pink-50 rounded-lg">
                            <div class="text-sm font-medium text-purple-900 mb-1">Next Recommendation</div>
                            <div class="text-xs text-purple-700">CMA Cost Analysis for Business Optimization</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-16 bg-gradient-to-r from-[#022B50] to-blue-600 text-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-2xl md:text-3xl font-bold mb-4">
                With Medex, expert professional support is just a few clicks away.
            </h2>
            <p class="text-lg mb-8">
                Medex connects you with verified Advocates, Chartered Accountants, Company Secretaries, and CMAs across India 24/7. 
                Whether it's legal advice, tax planning, corporate compliance, or financial management, our professionals are ready to help. 
                Book a consultation now and get the right expert support tailored to your business needs.
            </p>
            <a href="<?php echo e(route('register')); ?>" 
               class="bg-white text-[#022B50] px-8 py-3 rounded-lg font-semibold text-lg hover:bg-gray-100 transition-colors">
                Consult Professional Now
            </a>
        </div>
    </section>

    <!-- Benefits Section -->
    <section id="section4" class="py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 text-center mb-6">
                Benefits of Professional Consultation
            </h2>
            <p class="text-lg text-gray-600 text-center mb-12 max-w-4xl mx-auto">
                Professional consultation offers you clarity, confidence, and expert support across legal, financial, and compliance domains. 
                Here are the key benefits of consulting our verified Advocates, CAs, CSs, and CMAs:
            </p>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-gray-50 p-6 rounded-xl">
                    <h3 class="font-semibold text-lg mb-4 text-[#022B50]">Expert Legal & Financial Advice</h3>
                    <p class="text-gray-600">
                        Get guidance from verified Advocates for legal matters, CAs for taxation, CSs for compliance, 
                        and CMAs for financial planning. Expert advice to make informed business decisions.
                    </p>
                </div>
                <div class="bg-gray-50 p-6 rounded-xl">
                    <h3 class="font-semibold text-lg mb-4 text-[#022B50]">Comprehensive Professional Support</h3>
                    <p class="text-gray-600">
                        From contract drafting and legal documentation to tax planning and corporate filings, 
                        our professionals provide end-to-end support for your business needs.
                    </p>
                </div>
                <div class="bg-gray-50 p-6 rounded-xl">
                    <h3 class="font-semibold text-lg mb-4 text-[#022B50]">Cost-Effective Solutions</h3>
                    <p class="text-gray-600">
                        Avoid costly mistakes and penalties with expert advice. Our professionals help minimize risks 
                        and optimize your legal, tax, and compliance strategies.
                    </p>
                </div>
                <div class="bg-gray-50 p-6 rounded-xl">
                    <h3 class="font-semibold text-lg mb-4 text-[#022B50]">Multi-Domain Expertise</h3>
                    <p class="text-gray-600">
                        Access specialized knowledge across legal, accounting, company secretarial, and cost management domains 
                        through our network of qualified professionals.
                    </p>
                </div>
                <div class="bg-gray-50 p-6 rounded-xl">
                    <h3 class="font-semibold text-lg mb-4 text-[#022B50]">Strategic Business Guidance</h3>
                    <p class="text-gray-600">
                        Our professionals provide strategic advice for business growth, compliance management, 
                        risk mitigation, and financial optimization tailored to your specific requirements.
                    </p>
                </div>
                <div class="bg-gray-50 p-6 rounded-xl">
                    <h3 class="font-semibold text-lg mb-4 text-[#022B50]">Flexible Consultation Options</h3>
                    <p class="text-gray-600">
                        Choose from video, audio, or chat consultations with verified professionals. 
                        Get expert support on your schedule from anywhere, anytime.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Section -->
    <section id="section5" class="py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <h2 class="text-3xl md:text-4xl font-bold text-gray-900 text-center mb-6">
                Why Choose Medex for Professional Consultation?
            </h2>
            <div class="text-lg text-gray-600 text-center mb-12 max-w-4xl mx-auto">
                <p>
                    Medex is the leading platform connecting you with qualified Advocates, Chartered Accountants, Company Secretaries, 
                    and Certified Management Accountants. With 100,000+ cases resolved and a network of verified professionals, 
                    Medex stands out as the trusted destination for comprehensive legal, financial, and compliance solutions.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="font-semibold text-lg text-center mb-4 text-[#022B50]">Qualified & Verified Professionals</h3>
                    <p class="text-gray-600 text-center">
                        Connect with licensed Advocates, CAs, CSs, and CMAs with verified qualifications and proven experience
                    </p>
                </div>
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="font-semibold text-lg text-center mb-4 text-[#022B50]">Transparent & Affordable Pricing</h3>
                    <p class="text-gray-600 text-center">
                        Professional consultation doesn't have to be expensive. Clear, upfront pricing with no hidden costs
                    </p>
                </div>
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="font-semibold text-lg text-center mb-4 text-[#022B50]">Secure & Confidential</h3>
                    <p class="text-gray-600 text-center">
                        Your business information stays protected with end-to-end encryption and strict confidentiality protocols
                    </p>
                </div>
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="font-semibold text-lg text-center mb-4 text-[#022B50]">Multi-Domain Expertise</h3>
                    <p class="text-gray-600 text-center">
                        Access legal, taxation, compliance, and financial expertise through one integrated platform
                    </p>
                </div>
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="font-semibold text-lg text-center mb-4 text-[#022B50]">Streamlined Process</h3>
                    <p class="text-gray-600 text-center">
                        From consultation to documentation and compliance, we make professional services simple and efficient
                    </p>
                </div>
                <div class="bg-white p-6 rounded-xl shadow-sm border border-gray-200">
                    <h3 class="font-semibold text-lg text-center mb-4 text-[#022B50]">Flexible Consultation Modes</h3>
                    <p class="text-gray-600 text-center">
                        Choose from video calls, audio consultations, or chat sessions based on your preference and convenience
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Professional Showcase Section -->
    <section class="py-20 bg-gradient-to-br from-blue-50 to-indigo-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Our Professional Network</h2>
                <p class="text-xl text-gray-600">Connect with top-rated professionals across multiple domains</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Advocate Card -->
                <div class="professional-card group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Legal Advocates</h3>
                        <p class="text-gray-600 mb-4">Expert legal representation and advisory services</p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Criminal Law</li>
                            <li>• Civil Litigation</li>
                            <li>• Corporate Law</li>
                            <li>• Medical Negligence</li>
                        </ul>
                        <div class="mt-6">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">500+ Cases Handled</span>
                        </div>
                    </div>
                </div>
                
                <!-- CA Card -->
                <div class="professional-card group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-r from-green-500 to-emerald-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Chartered Accountants</h3>
                        <p class="text-gray-600 mb-4">Financial expertise and compliance solutions</p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Tax Planning</li>
                            <li>• Financial Auditing</li>
                            <li>• GST Compliance</li>
                            <li>• Investment Advisory</li>
                        </ul>
                        <div class="mt-6">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">1000+ Audits Completed</span>
                        </div>
                    </div>
                </div>
                
                <!-- CS Card -->
                <div class="professional-card group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-r from-purple-500 to-pink-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Company Secretaries</h3>
                        <p class="text-gray-600 mb-4">Corporate governance and compliance experts</p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Company Formation</li>
                            <li>• Board Meetings</li>
                            <li>• Regulatory Compliance</li>
                            <li>• Annual Filings</li>
                        </ul>
                        <div class="mt-6">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-purple-100 text-purple-800">300+ Companies Managed</span>
                        </div>
                    </div>
                </div>
                
                <!-- CMA Card -->
                <div class="professional-card group">
                    <div class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-r from-orange-500 to-red-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 00-2 2h2a2 2 0 002-2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Cost & Management Accountants</h3>
                        <p class="text-gray-600 mb-4">Strategic cost management and optimization</p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Cost Analysis</li>
                            <li>• Budget Planning</li>
                            <li>• Performance Management</li>
                            <li>• Strategic Advisory</li>
                        </ul>
                        <div class="mt-6">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800">200+ Projects Optimized</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    

    <!-- Testimonials & Success Metrics Section -->
    <section class="py-20 bg-gradient-to-br from-gray-50 to-blue-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Success Metrics -->
            <div class="text-center mb-16">
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Trusted by Thousands</h2>
                <p class="text-xl text-gray-600 mb-12">Real results from real professionals across India</p>
                
                <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                    <div class="text-center">
                        <div class="text-4xl font-bold text-blue-600 mb-2">5,00,000+</div>
                        <div class="text-gray-600">Cases Resolved</div>
                    </div>
                    <div class="text-center">
                        <div class="text-4xl font-bold text-green-600 mb-2">1,000+</div>
                        <div class="text-gray-600">Expert Professionals</div>
                    </div>
                    <div class="text-center">
                        <div class="text-4xl font-bold text-purple-600 mb-2">98.5%</div>
                        <div class="text-gray-600">Client Satisfaction</div>
                    </div>
                    <div class="text-center">
                        <div class="text-4xl font-bold text-orange-600 mb-2">24/7</div>
                        <div class="text-gray-600">Support Available</div>
                    </div>
                </div>
            </div>
            
            <!-- Testimonials -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- Testimonial 1 -->
                <div class="professional-card text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <span class="text-white font-bold text-xl">DR</span>
                    </div>
                    <h4 class="font-semibold text-lg text-gray-900 mb-2">Dr. Rajesh Kumar</h4>
                    <p class="text-sm text-gray-600 mb-4">Cardiologist, Mumbai</p>
                    <div class="flex justify-center mb-4">
                        <div class="flex text-yellow-400">
                            ⭐⭐⭐⭐⭐
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"MEDEX helped me resolve a complex medical negligence case efficiently. The legal experts were knowledgeable and the process was seamless."</p>
                </div>
                
                <!-- Testimonial 2 -->
                <div class="professional-card text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-green-500 to-emerald-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <span class="text-white font-bold text-xl">AS</span>
                    </div>
                    <h4 class="font-semibold text-lg text-gray-900 mb-2">Asha Sharma</h4>
                    <p class="text-sm text-gray-600 mb-4">Hospital Administrator, Delhi</p>
                    <div class="flex justify-center mb-4">
                        <div class="flex text-yellow-400">
                            ⭐⭐⭐⭐⭐
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"The CA services for our hospital's tax compliance were exceptional. Saved us both time and money with their expert guidance."</p>
                </div>
                
                <!-- Testimonial 3 -->
                <div class="professional-card text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-purple-500 to-pink-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <span class="text-white font-bold text-xl">MG</span>
                    </div>
                    <h4 class="font-semibold text-lg text-gray-900 mb-2">Dr. Meera Gupta</h4>
                    <p class="text-sm text-gray-600 mb-4">Dental Clinic Owner, Bangalore</p>
                    <div class="flex justify-center mb-4">
                        <div class="flex text-yellow-400">
                            ⭐⭐⭐⭐⭐
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"Corporate compliance for my clinic was handled professionally. The CS experts made business registration and annual filings effortless."</p>
                </div>
                
                <!-- Testimonial 4 -->
                <div class="professional-card text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-orange-500 to-red-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <span class="text-white font-bold text-xl">VK</span>
                    </div>
                    <h4 class="font-semibold text-lg text-gray-900 mb-2">Vikram Khanna</h4>
                    <p class="text-sm text-gray-600 mb-4">Pharma Business Owner, Pune</p>
                    <div class="flex justify-center mb-4">
                        <div class="flex text-yellow-400">
                            ⭐⭐⭐⭐⭐
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"The CMA experts helped optimize our cost structure and improved our profit margins by 15%. Highly recommend their services."</p>
                </div>
                
                <!-- Testimonial 5 -->
                <div class="professional-card text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-indigo-500 to-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <span class="text-white font-bold text-xl">SK</span>
                    </div>
                    <h4 class="font-semibold text-lg text-gray-900 mb-2">Dr. Suresh Khurana</h4>
                    <p class="text-sm text-gray-600 mb-4">Medical Practice, Chennai</p>
                    <div class="flex justify-center mb-4">
                        <div class="flex text-yellow-400">
                            ⭐⭐⭐⭐⭐
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"From legal notices to tax planning, MEDEX is my one-stop solution for all professional services. Reliable and efficient."</p>
                </div>
                
                <!-- Testimonial 6 -->
                <div class="professional-card text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-teal-500 to-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <span class="text-white font-bold text-xl">PP</span>
                    </div>
                    <h4 class="font-semibold text-lg text-gray-900 mb-2">Dr. Priya Patel</h4>
                    <p class="text-sm text-gray-600 mb-4">Gynecologist, Ahmedabad</p>
                    <div class="flex justify-center mb-4">
                        <div class="flex text-yellow-400">
                            ⭐⭐⭐⭐⭐
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"The AI-powered compliance monitoring gives me peace of mind. I can focus on my patients while MEDEX handles all regulatory requirements."</p>
                </div>
            </div>
            
            <!-- Call to Action -->
            <div class="text-center mt-16">
                <h3 class="text-2xl font-bold text-gray-900 mb-4">Join Thousands of Satisfied Professionals</h3>
                <p class="text-gray-600 mb-8">Get expert consultation for your professional needs today</p>
                <a href="/register" class="inline-flex items-center px-8 py-4 border border-transparent text-base font-medium rounded-lg shadow-sm text-white bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 transition-all transform hover:scale-105">
                    Start Your Free Consultation
                    <svg class="ml-2 -mr-1 w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10.293 3.293a1 1 0 011.414 0l6 6a1 1 0 010 1.414l-6 6a1 1 0 01-1.414-1.414L14.586 11H3a1 1 0 110-2h11.586l-4.293-4.293a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                    </svg>
                </a>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section id="section6" class="py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 lg:grid-cols-5 gap-12">
                <div class="lg:col-span-2">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">
                        Frequently Asked Questions on Professional Consultation
                    </h2>
                    <p class="text-gray-600">
                        Explore answers to common questions about our professional consultation services with Advocates, 
                        CAs, CSs, and CMAs, including pricing, expertise, and consultation procedures.
                    </p>
                </div>
                
                <div class="lg:col-span-3">
                    <div class="space-y-4">
                        <!-- FAQ Items -->
                        <div class="border border-gray-200 rounded-lg">
                            <button class="w-full px-6 py-4 text-left font-semibold text-gray-900 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                                    onclick="toggleFaq(0)">
                                What professional services are available on Medex?
                                <svg class="float-right w-5 h-5 transform transition-transform" id="faq-icon-0" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <div class="px-6 pb-4 hidden" id="faq-content-0">
                                <p class="text-gray-600">
                                    Medex connects you with qualified Advocates for legal services, Chartered Accountants for taxation and financial advice, 
                                    Company Secretaries for corporate compliance, and CMAs for cost management and financial planning.
                                </p>
                            </div>
                        </div>

                        <div class="border border-gray-200 rounded-lg">
                            <button class="w-full px-6 py-4 text-left font-semibold text-gray-900 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                                    onclick="toggleFaq(1)">
                                Do I need to visit professionals in person?
                                <svg class="float-right w-5 h-5 transform transition-transform" id="faq-icon-1" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <div class="px-6 pb-4 hidden" id="faq-content-1">
                                <p class="text-gray-600">
                                    No, you can consult with Advocates, CAs, CSs, and CMAs online through our secure platform via video, audio, or chat.
                                </p>
                            </div>
                        </div>

                        <div class="border border-gray-200 rounded-lg">
                            <button class="w-full px-6 py-4 text-left font-semibold text-gray-900 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                                    onclick="toggleFaq(2)">
                                Are all professionals on Medex qualified and verified?
                                <svg class="float-right w-5 h-5 transform transition-transform" id="faq-icon-2" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <div class="px-6 pb-4 hidden" id="faq-content-2">
                                <p class="text-gray-600">
                                    Yes, all professionals on Medex are verified. Our Advocates, CAs, CSs, and CMAs have valid licenses and proven experience in their respective fields.
                                </p>
                            </div>
                        </div>

                        <div class="border border-gray-200 rounded-lg">
                            <button class="w-full px-6 py-4 text-left font-semibold text-gray-900 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                                    onclick="toggleFaq(3)">
                                How are consultation fees structured?
                                <svg class="float-right w-5 h-5 transform transition-transform" id="faq-icon-3" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <div class="px-6 pb-4 hidden" id="faq-content-3">
                                <p class="text-gray-600">
                                    Professional consultation fees start at ₹399 for a 30-minute session. Pricing varies based on the professional type and complexity of services. 
                                    Clear pricing is provided before booking.
                                </p>
                            </div>
                        </div>

                        <div class="border border-gray-200 rounded-lg">
                            <button class="w-full px-6 py-4 text-left font-semibold text-gray-900 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500" 
                                    onclick="toggleFaq(4)">
                                Is my business information secure on Medex?
                                <svg class="float-right w-5 h-5 transform transition-transform" id="faq-icon-4" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                                </svg>
                            </button>
                            <div class="px-6 pb-4 hidden" id="faq-content-4">
                                <p class="text-gray-600">
                                    Yes, Medex uses advanced security systems to protect your data. All consultations are private and confidential with strict data protection protocols.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer Component -->
    <?php echo $__env->make('components.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script>
        // Service navigation
        document.addEventListener('DOMContentLoaded', function() {
            const serviceItems = document.querySelectorAll('.service-item');
            
            serviceItems.forEach(item => {
                item.addEventListener('click', function() {
                    // Remove active class from all items
                    serviceItems.forEach(i => {
                        i.classList.remove('bg-[#022B50]', 'text-white');
                        i.classList.add('hover:bg-gray-50');
                    });
                    
                    // Add active class to clicked item
                    this.classList.add('bg-[#022B50]', 'text-white');
                    this.classList.remove('hover:bg-gray-50');
                    
                    // Hide all service content
                    document.querySelectorAll('.service-content').forEach(content => {
                        content.classList.add('hidden');
                    });
                    
                    // Show selected service content
                    const serviceId = this.getAttribute('data-service');
                    const serviceContent = document.getElementById(serviceId);
                    if (serviceContent) {
                        serviceContent.classList.remove('hidden');
                    }
                });
            });
        });

        // FAQ toggle functionality
        function toggleFaq(index) {
            const content = document.getElementById(`faq-content-${index}`);
            const icon = document.getElementById(`faq-icon-${index}`);
            
            if (content.classList.contains('hidden')) {
                content.classList.remove('hidden');
                icon.style.transform = 'rotate(180deg)';
            } else {
                content.classList.add('hidden');
                icon.style.transform = 'rotate(0deg)';
            }
        }
    </script><?php /**PATH C:\laragon\www\Medex\resources\views/welcome.blade.php ENDPATH**/ ?>