

<?php $__env->startSection('content'); ?>
<div class="auth-header">
    <h1>Welcome Back</h1>
    <p>Sign in to your Medex account</p>
</div>

<?php if($errors->any()): ?>
    <div class="error-messages">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<?php if(session('success')): ?>
    <div class="success-message">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<form method="POST" action="<?php echo e(route('login')); ?>">
    <?php echo csrf_field(); ?>
    
    <div class="form-group">
        <label class="form-label" for="email">Email Address</label>
        <input id="email" class="form-input" type="email" name="email" value="<?php echo e(old('email')); ?>" required autofocus>
    </div>
    
    <div class="form-group">
        <label class="form-label" for="password">Password</label>
        <input id="password" class="form-input" type="password" name="password" required>
    </div>
    
    <div class="form-group">
        <label style="display: flex; align-items: center; gap: 0.5rem;">
            <input type="checkbox" name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
            <span style="font-size: 0.9rem;">Remember me</span>
        </label>
    </div>
    
    <div class="form-group">
        <button class="btn btn-primary" type="submit">Sign In</button>
    </div>
</form>

<div class="auth-links">
    <p>Don't have an account? <a href="<?php echo e(route('register')); ?>">Create one</a></p>
    
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Medex\resources\views/auth/login.blade.php ENDPATH**/ ?>