@extends('layouts.app')

@section('title', 'Review Details')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Review Header -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">
                            <i class="fas fa-star text-warning me-2"></i>
                            Review Details
                        </h5>
                        <div class="d-flex gap-2">
                            @if(Auth::id() === $review->reviewer_id && $review->created_at->diffInHours(now()) <= 24)
                                <button class="btn btn-outline-primary btn-sm" onclick="editReview()">
                                    <i class="fas fa-edit me-1"></i>Edit
                                </button>
                            @endif
                            @if(Auth::id() !== $review->reviewer_id && Auth::user()->user_type !== 'admin')
                                <button class="btn btn-outline-danger btn-sm" onclick="reportReview()">
                                    <i class="fas fa-flag me-1"></i>Report
                                </button>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Rating Display -->
                    <div class="mb-3">
                        <div class="d-flex align-items-center">
                            <div class="star-display me-3">
                                @for($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star {{ $i <= $review->rating ? 'text-warning' : 'text-light' }}"></i>
                                @endfor
                            </div>
                            <span class="h5 mb-0">{{ $review->rating }}/5</span>
                            <span class="text-muted ms-2">
                                ({{ ['', 'Poor', 'Fair', 'Good', 'Very Good', 'Excellent'][$review->rating] }})
                            </span>
                        </div>
                    </div>

                    <!-- Review Content -->
                    <div class="review-content">
                        <p class="mb-0">{{ $review->comment }}</p>
                    </div>

                    <!-- Review Metadata -->
                    <div class="mt-3 pt-3 border-top">
                        <div class="row text-muted small">
                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>Reviewed by:</strong> 
                                    @if($review->is_anonymous && Auth::id() !== $review->reviewer_id && Auth::user()->user_type !== 'admin')
                                        <span class="text-secondary">Anonymous User</span>
                                    @else
                                        {{ $review->reviewer->name }}
                                        @if($review->is_anonymous)
                                            <span class="badge bg-secondary ms-1">Anonymous</span>
                                        @endif
                                    @endif
                                </p>
                                <p class="mb-1">
                                    <strong>Reviewed on:</strong> {{ $review->created_at->format('d M Y, h:i A') }}
                                </p>
                                @if($review->created_at != $review->updated_at)
                                    <p class="mb-0">
                                        <small class="text-info">
                                            <i class="fas fa-edit me-1"></i>
                                            Updated on {{ $review->updated_at->format('d M Y, h:i A') }}
                                        </small>
                                    </p>
                                @endif
                            </div>
                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>For:</strong> 
                                    @if(Auth::id() === $review->reviewee_id || Auth::user()->user_type === 'admin')
                                        {{ $review->reviewee->name }}
                                    @else
                                        {{ $review->reviewee->user_type === 'professional' ? 'Professional' : 'Client' }}
                                    @endif
                                </p>
                                <p class="mb-1">
                                    <strong>Consultation:</strong> {{ $review->consultation->scheduled_at->format('d M Y') }}
                                </p>
                                <p class="mb-0">
                                    <strong>Status:</strong> 
                                    <span class="badge bg-{{ $review->status === 'active' ? 'success' : 'warning' }}">
                                        {{ ucfirst($review->status) }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Consultation Details -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Related Consultation</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            @if($review->reviewer->user_type === 'client')
                                <p class="mb-1"><strong>Professional:</strong> {{ $review->consultation->professional->user->name }}</p>
                                <p class="mb-1"><strong>Specialty:</strong> {{ $review->consultation->professional->specialty }}</p>
                            @else
                                <p class="mb-1"><strong>Client:</strong> {{ $review->consultation->client->user->name }}</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <p class="mb-1"><strong>Date:</strong> {{ $review->consultation->scheduled_at->format('d M Y') }}</p>
                            <p class="mb-1"><strong>Duration:</strong> {{ $review->consultation->duration }} minutes</p>
                            <p class="mb-1"><strong>Type:</strong> {{ ucfirst($review->consultation->consultation_type) }}</p>
                        </div>
                    </div>
                    
                    <div class="mt-3">
                        <a href="{{ route('consultation.show', $review->consultation) }}" class="btn btn-outline-primary btn-sm">
                            <i class="fas fa-eye me-1"></i>View Consultation Details
                        </a>
                    </div>
                </div>
            </div>

            <!-- Admin Actions (if admin) -->
            @if(Auth::user()->user_type === 'admin')
            <div class="card mb-4">
                <div class="card-header bg-warning text-dark">
                    <h6 class="mb-0">Admin Actions</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('review.update-status', $review) }}" method="POST" class="d-inline">
                        @csrf
                        @method('PATCH')
                        
                        <div class="row align-items-end">
                            <div class="col-md-6">
                                <label class="form-label">Review Status</label>
                                <select name="status" class="form-select">
                                    <option value="active" {{ $review->status === 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="hidden" {{ $review->status === 'hidden' ? 'selected' : '' }}>Hidden</option>
                                    <option value="flagged" {{ $review->status === 'flagged' ? 'selected' : '' }}>Flagged</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-warning">
                                    <i class="fas fa-save me-1"></i>Update Status
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            @endif

            <!-- Back Navigation -->
            <div class="text-center">
                <a href="{{ url()->previous() }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Edit Review Modal -->
@if(Auth::id() === $review->reviewer_id && $review->created_at->diffInHours(now()) <= 24)
<div class="modal fade" id="editReviewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form action="{{ route('review.update', $review) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="modal-header">
                    <h5 class="modal-title">Edit Review</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <!-- Rating -->
                    <div class="mb-3">
                        <label class="form-label"><strong>Rating</strong></label>
                        <div class="star-rating-edit">
                            <input type="hidden" name="rating" id="editRating" value="{{ $review->rating }}" required>
                            <div class="star-rating">
                                @for($i = 1; $i <= 5; $i++)
                                    <span class="star" data-rating="{{ $i }}" onclick="setEditRating({{ $i }})">
                                        <i class="{{ $i <= $review->rating ? 'fas' : 'far' }} fa-star"></i>
                                    </span>
                                @endfor
                            </div>
                        </div>
                    </div>

                    <!-- Comment -->
                    <div class="mb-3">
                        <label for="editComment" class="form-label"><strong>Comment</strong></label>
                        <textarea name="comment" id="editComment" class="form-control" rows="4" required>{{ $review->comment }}</textarea>
                    </div>

                    <!-- Anonymous -->
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_anonymous" id="editAnonymous" value="1" {{ $review->is_anonymous ? 'checked' : '' }}>
                            <label class="form-check-label" for="editAnonymous">
                                Post anonymously
                            </label>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Review</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif

<!-- Report Review Modal -->
@if(Auth::id() !== $review->reviewer_id && Auth::user()->user_type !== 'admin')
<div class="modal fade" id="reportReviewModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('review.report', $review) }}" method="POST">
                @csrf
                
                <div class="modal-header">
                    <h5 class="modal-title">Report Review</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="reportReason" class="form-label">Reason for reporting</label>
                        <select name="reason" id="reportReason" class="form-select" required>
                            <option value="">Select a reason...</option>
                            <option value="inappropriate_language">Inappropriate Language</option>
                            <option value="personal_attack">Personal Attack</option>
                            <option value="false_information">False Information</option>
                            <option value="spam">Spam</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label for="reportDetails" class="form-label">Additional Details</label>
                        <textarea name="details" id="reportDetails" class="form-control" rows="3" placeholder="Please provide more details..."></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Submit Report</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif

@push('styles')
<style>
.star-display {
    font-size: 1.25rem;
}

.star-rating .star {
    cursor: pointer;
    font-size: 1.5rem;
    margin-right: 0.25rem;
}

.star i {
    color: #e0e0e0;
    transition: color 0.2s;
}

.star:hover i,
.star.active i {
    color: #ffc107;
}

.review-content {
    font-size: 1.1rem;
    line-height: 1.6;
}
</style>
@endpush

@push('scripts')
<script>
function editReview() {
    const modal = new bootstrap.Modal(document.getElementById('editReviewModal'));
    modal.show();
}

function reportReview() {
    const modal = new bootstrap.Modal(document.getElementById('reportReviewModal'));
    modal.show();
}

function setEditRating(rating) {
    document.getElementById('editRating').value = rating;
    
    const stars = document.querySelectorAll('.star-rating .star');
    stars.forEach((star, index) => {
        const icon = star.querySelector('i');
        if (index < rating) {
            icon.classList.remove('far');
            icon.classList.add('fas');
        } else {
            icon.classList.remove('fas');
            icon.classList.add('far');
        }
    });
}
</script>
@endpush
@endsection