@extends('layouts.app')

@section('title', 'Professional Reviews - ' . $professional->user->name)

@section('content')
<div class="container mt-4">
    <div class="row">
        <!-- Professional Info -->
        <div class="col-lg-4 mb-4">
            <div class="card sticky-top" style="top: 1rem;">
                <div class="card-body text-center">
                    <div class="mb-3">
                        @if($professional->profile_photo)
                            <img src="{{ asset('storage/' . $professional->profile_photo) }}" 
                                 class="rounded-circle" width="100" height="100" alt="Profile">
                        @else
                            <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                 style="width: 100px; height: 100px;">
                                <span class="text-white fs-2">{{ substr($professional->user->name, 0, 1) }}</span>
                            </div>
                        @endif
                    </div>
                    
                    <h5 class="card-title">{{ $professional->user->name }}</h5>
                    <p class="text-muted">{{ $professional->specialty }}</p>
                    
                    <!-- Overall Rating -->
                    <div class="rating-summary mb-3">
                        <div class="d-flex align-items-center justify-content-center mb-2">
                            <span class="h3 mb-0 me-2">{{ number_format($ratingStats->average_rating ?? 0, 1) }}</span>
                            <div class="star-display">
                                @for($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star {{ $i <= round($ratingStats->average_rating ?? 0) ? 'text-warning' : 'text-light' }}"></i>
                                @endfor
                            </div>
                        </div>
                        <p class="text-muted small">Based on {{ $ratingStats->total_reviews ?? 0 }} reviews</p>
                    </div>

                    <!-- Rating Breakdown -->
                    @if($ratingStats && $ratingStats->total_reviews > 0)
                    <div class="rating-breakdown">
                        <div class="text-start small">
                            @for($i = 5; $i >= 1; $i--)
                                @php
                                    $count = $ratingStats->{['', 'one_star', 'two_star', 'three_star', 'four_star', 'five_star'][$i]} ?? 0;
                                    $percentage = $ratingStats->total_reviews > 0 ? ($count / $ratingStats->total_reviews) * 100 : 0;
                                @endphp
                                <div class="d-flex align-items-center mb-1">
                                    <span class="me-2">{{ $i }}</span>
                                    <i class="fas fa-star text-warning me-2"></i>
                                    <div class="progress flex-fill me-2" style="height: 8px;">
                                        <div class="progress-bar bg-warning" style="width: {{ $percentage }}%"></div>
                                    </div>
                                    <span class="text-muted">{{ $count }}</span>
                                </div>
                            @endfor
                        </div>
                    </div>
                    @endif

                    <!-- Action Buttons -->
                    <div class="mt-3">
                        @if(Auth::check() && Auth::user()->user_type === 'client')
                            <a href="{{ route('client.book', $professional) }}" class="btn btn-primary">
                                <i class="fas fa-calendar-plus me-1"></i>Book Consultation
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- Reviews List -->
        <div class="col-lg-8">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h3>Reviews & Ratings</h3>
                
                <!-- Filter Options -->
                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" 
                            data-bs-toggle="dropdown">
                        <i class="fas fa-filter me-1"></i>Filter
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="{{ request()->url() }}">All Reviews</a></li>
                        <li><hr class="dropdown-divider"></li>
                        @for($i = 5; $i >= 1; $i--)
                            <li>
                                <a class="dropdown-item {{ request('rating') == $i ? 'active' : '' }}" 
                                   href="{{ request()->fullUrlWithQuery(['rating' => $i]) }}">
                                    {{ $i }} Star{{ $i > 1 ? 's' : '' }}
                                </a>
                            </li>
                        @endfor
                    </ul>
                </div>
            </div>

            @if($reviews->count() > 0)
                <!-- Reviews -->
                <div class="reviews-list">
                    @foreach($reviews as $review)
                        <div class="card mb-3">
                            <div class="card-body">
                                <!-- Review Header -->
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div class="d-flex align-items-center">
                                        <div class="me-3">
                                            @if($review->is_anonymous)
                                                <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                                     style="width: 40px; height: 40px;">
                                                    <i class="fas fa-user text-white"></i>
                                                </div>
                                            @else
                                                <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                                     style="width: 40px; height: 40px;">
                                                    <span class="text-white">{{ substr($review->reviewer->name, 0, 1) }}</span>
                                                </div>
                                            @endif
                                        </div>
                                        <div>
                                            <h6 class="mb-1">
                                                {{ $review->is_anonymous ? 'Anonymous Client' : $review->reviewer->name }}
                                            </h6>
                                            <div class="star-display small">
                                                @for($i = 1; $i <= 5; $i++)
                                                    <i class="fas fa-star {{ $i <= $review->rating ? 'text-warning' : 'text-light' }}"></i>
                                                @endfor
                                                <span class="text-muted ms-2">{{ $review->created_at->format('M d, Y') }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    @if(Auth::check())
                                        <div class="dropdown">
                                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                                    type="button" data-bs-toggle="dropdown">
                                                <i class="fas fa-ellipsis-h"></i>
                                            </button>
                                            <ul class="dropdown-menu">
                                                @if(Auth::id() === $review->reviewer_id)
                                                    <li>
                                                        <a class="dropdown-item" href="{{ route('review.show', $review) }}">
                                                            <i class="fas fa-eye me-2"></i>View Details
                                                        </a>
                                                    </li>
                                                    @if($review->created_at->diffInHours(now()) <= 24)
                                                        <li>
                                                            <a class="dropdown-item" href="{{ route('review.edit', $review) }}">
                                                                <i class="fas fa-edit me-2"></i>Edit Review
                                                            </a>
                                                        </li>
                                                    @endif
                                                @else
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#" 
                                                           onclick="reportReview({{ $review->id }})">
                                                            <i class="fas fa-flag me-2"></i>Report Review
                                                        </a>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>
                                    @endif
                                </div>

                                <!-- Review Content -->
                                <div class="review-content">
                                    <p class="mb-2">{{ $review->comment }}</p>
                                </div>

                                <!-- Consultation Context -->
                                <div class="consultation-context mt-3 pt-2 border-top">
                                    <small class="text-muted">
                                        <i class="fas fa-calendar me-1"></i>
                                        Consultation on {{ $review->consultation->scheduled_at->format('M d, Y') }}
                                        <span class="mx-2">•</span>
                                        <i class="fas fa-clock me-1"></i>
                                        {{ $review->consultation->duration }} minutes
                                    </small>
                                </div>

                                <!-- Helpful Actions -->
                                <div class="review-actions mt-3">
                                    <div class="d-flex align-items-center">
                                        <button class="btn btn-outline-success btn-sm me-2" onclick="markHelpful({{ $review->id }})">
                                            <i class="fas fa-thumbs-up me-1"></i>Helpful
                                        </button>
                                        <small class="text-muted">Was this review helpful?</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center">
                    {{ $reviews->links() }}
                </div>
            @else
                <!-- No Reviews -->
                <div class="text-center py-5">
                    <i class="fas fa-star fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">No reviews yet</h5>
                    <p class="text-muted">
                        @if(request('rating'))
                            No {{ request('rating') }}-star reviews found.
                            <a href="{{ request()->url() }}">View all reviews</a>
                        @else
                            Be the first to leave a review for this professional.
                        @endif
                    </p>
                    
                    @if(Auth::check() && Auth::user()->user_type === 'client')
                        <a href="{{ route('client.book', $professional) }}" class="btn btn-primary">
                            <i class="fas fa-calendar-plus me-1"></i>Book a Consultation
                        </a>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>

@push('styles')
<style>
.star-display {
    font-size: 0.875rem;
}

.rating-breakdown .progress {
    background-color: #f8f9fa;
}

.review-content {
    line-height: 1.6;
}

.consultation-context {
    background-color: #f8f9fa;
    border-radius: 0.375rem;
    padding: 0.5rem;
}

.card {
    transition: box-shadow 0.2s;
}

.card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.sticky-top {
    z-index: 1020;
}
</style>
@endpush

@push('scripts')
<script>
function reportReview(reviewId) {
    if (confirm('Are you sure you want to report this review?')) {
        // In a real application, this would send an AJAX request
        alert('Review reported. Thank you for your feedback.');
    }
}

function markHelpful(reviewId) {
    // In a real application, this would send an AJAX request to track helpful votes
    alert('Thank you for your feedback!');
}
</script>
@endpush
@endsection