@extends('layouts.app')

@section('title', 'Write Review')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <!-- Consultation Summary -->
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-star me-2"></i>
                        Write Review for Your Consultation
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            @if(Auth::user()->user_type === 'client')
                                <h6>Professional Details</h6>
                                <p class="mb-1"><strong>Name:</strong> {{ $consultation->professional->user->name }}</p>
                                <p class="mb-1"><strong>Specialty:</strong> {{ $consultation->professional->specialty }}</p>
                                <p class="mb-1"><strong>Experience:</strong> {{ $consultation->professional->experience_years }} years</p>
                            @else
                                <h6>Client Details</h6>
                                <p class="mb-1"><strong>Name:</strong> {{ $consultation->client->user->name }}</p>
                                <p class="mb-1"><strong>Age:</strong> {{ $consultation->client->age ?? 'Not specified' }}</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <h6>Consultation Details</h6>
                            <p class="mb-1"><strong>Date:</strong> {{ $consultation->scheduled_at->format('d M Y') }}</p>
                            <p class="mb-1"><strong>Time:</strong> {{ $consultation->scheduled_at->format('h:i A') }}</p>
                            <p class="mb-1"><strong>Duration:</strong> {{ $consultation->duration }} minutes</p>
                            <p class="mb-1"><strong>Type:</strong> {{ ucfirst($consultation->consultation_type) }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Review Form -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Your Review</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('review.store', $consultation) }}" method="POST">
                        @csrf
                        
                        <!-- Rating Section -->
                        <div class="mb-4">
                            <label class="form-label">
                                <strong>Overall Rating</strong>
                                <span class="text-danger">*</span>
                            </label>
                            <div class="rating-input">
                                <input type="hidden" name="rating" id="rating" value="" required>
                                <div class="star-rating">
                                    @for($i = 1; $i <= 5; $i++)
                                        <span class="star" data-rating="{{ $i }}" onclick="setRating({{ $i }})">
                                            <i class="far fa-star"></i>
                                        </span>
                                    @endfor
                                </div>
                                <div class="rating-text text-muted mt-2" id="ratingText">
                                    Click on stars to rate
                                </div>
                            </div>
                            @error('rating')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Review Categories (for different perspectives) -->
                        @if(Auth::user()->user_type === 'client')
                        <div class="mb-4">
                            <label class="form-label"><strong>What would you like to highlight?</strong></label>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="helpful" name="categories[]" value="helpful">
                                        <label class="form-check-label" for="helpful">
                                            <i class="fas fa-hands-helping text-success me-1"></i>Very Helpful
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="professional" name="categories[]" value="professional">
                                        <label class="form-check-label" for="professional">
                                            <i class="fas fa-user-tie text-primary me-1"></i>Professional
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="knowledgeable" name="categories[]" value="knowledgeable">
                                        <label class="form-check-label" for="knowledgeable">
                                            <i class="fas fa-brain text-info me-1"></i>Knowledgeable
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="timely" name="categories[]" value="timely">
                                        <label class="form-check-label" for="timely">
                                            <i class="fas fa-clock text-warning me-1"></i>On Time
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="clear" name="categories[]" value="clear">
                                        <label class="form-check-label" for="clear">
                                            <i class="fas fa-comments text-secondary me-1"></i>Clear Communication
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="solution" name="categories[]" value="solution">
                                        <label class="form-check-label" for="solution">
                                            <i class="fas fa-lightbulb text-danger me-1"></i>Good Solutions
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @else
                        <div class="mb-4">
                            <label class="form-label"><strong>Client Qualities</strong></label>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="cooperative" name="categories[]" value="cooperative">
                                        <label class="form-check-label" for="cooperative">
                                            <i class="fas fa-handshake text-success me-1"></i>Cooperative
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="punctual" name="categories[]" value="punctual">
                                        <label class="form-check-label" for="punctual">
                                            <i class="fas fa-clock text-warning me-1"></i>Punctual
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="clear_communication" name="categories[]" value="clear_communication">
                                        <label class="form-check-label" for="clear_communication">
                                            <i class="fas fa-comments text-primary me-1"></i>Clear Communication
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="respectful" name="categories[]" value="respectful">
                                        <label class="form-check-label" for="respectful">
                                            <i class="fas fa-heart text-danger me-1"></i>Respectful
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif

                        <!-- Written Review -->
                        <div class="mb-4">
                            <label for="comment" class="form-label">
                                <strong>Your Review</strong>
                                <span class="text-danger">*</span>
                            </label>
                            <textarea name="comment" id="comment" class="form-control" rows="4" 
                                      placeholder="Share your experience... (minimum 10 characters)" 
                                      required>{{ old('comment') }}</textarea>
                            <div class="form-text">
                                Minimum 10 characters. Maximum 1000 characters.
                                <span id="charCount" class="float-end">0/1000</span>
                            </div>
                            @error('comment')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Privacy Options -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="is_anonymous" id="is_anonymous" value="1">
                                <label class="form-check-label" for="is_anonymous">
                                    <strong>Post anonymously</strong>
                                    <small class="d-block text-muted">
                                        Your name will be hidden from this review
                                    </small>
                                </label>
                            </div>
                        </div>

                        <!-- Review Guidelines -->
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle me-2"></i>Review Guidelines</h6>
                            <ul class="mb-0 small">
                                <li>Be honest and constructive in your feedback</li>
                                <li>Avoid personal attacks or inappropriate language</li>
                                <li>Focus on the consultation experience</li>
                                <li>You can edit your review within 24 hours</li>
                                <li>Reviews help improve our platform for everyone</li>
                            </ul>
                        </div>

                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('consultation.show', $consultation) }}" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-2"></i>Back to Consultation
                            </a>
                            <button type="submit" class="btn btn-primary" id="submitBtn" disabled>
                                <i class="fas fa-star me-2"></i>Submit Review
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.star-rating {
    font-size: 2rem;
    line-height: 1;
}

.star {
    cursor: pointer;
    transition: all 0.2s;
    margin-right: 0.25rem;
}

.star:hover i,
.star.active i {
    color: #ffc107;
}

.star i {
    color: #e0e0e0;
}

.star.active i {
    content: "\f005";
    font-family: "Font Awesome 5 Free";
    font-weight: 900;
}

.rating-text {
    font-size: 0.875rem;
}

.form-check {
    margin-bottom: 0.5rem;
}

#comment:focus {
    border-color: #0d6efd;
    box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
}
</style>
@endpush

@push('scripts')
<script>
let selectedRating = 0;
const ratingTexts = {
    1: 'Poor - Very unsatisfied',
    2: 'Fair - Below expectations',
    3: 'Good - Meets expectations',
    4: 'Very Good - Above expectations',
    5: 'Excellent - Outstanding experience'
};

function setRating(rating) {
    selectedRating = rating;
    document.getElementById('rating').value = rating;
    
    // Update star display
    const stars = document.querySelectorAll('.star');
    stars.forEach((star, index) => {
        if (index < rating) {
            star.classList.add('active');
            star.querySelector('i').classList.remove('far');
            star.querySelector('i').classList.add('fas');
        } else {
            star.classList.remove('active');
            star.querySelector('i').classList.remove('fas');
            star.querySelector('i').classList.add('far');
        }
    });
    
    // Update rating text
    document.getElementById('ratingText').textContent = ratingTexts[rating];
    
    // Enable submit button if both rating and comment are provided
    checkFormValidity();
}

// Character counter for comment
document.getElementById('comment').addEventListener('input', function() {
    const maxLength = 1000;
    const currentLength = this.value.length;
    
    document.getElementById('charCount').textContent = currentLength + '/' + maxLength;
    
    if (currentLength > maxLength) {
        this.value = this.value.substring(0, maxLength);
        document.getElementById('charCount').textContent = maxLength + '/' + maxLength;
    }
    
    checkFormValidity();
});

function checkFormValidity() {
    const rating = selectedRating > 0;
    const comment = document.getElementById('comment').value.length >= 10;
    
    document.getElementById('submitBtn').disabled = !(rating && comment);
}

// Initialize character counter
document.addEventListener('DOMContentLoaded', function() {
    const commentField = document.getElementById('comment');
    commentField.dispatchEvent(new Event('input'));
});
</script>
@endpush
@endsection