@extends('layouts.app')

@section('title', 'Professional Dashboard')

@section('content')
<div class="container-fluid mt-4">
    <!-- Welcome Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Welcome back, {{ auth()->user()->name }}! 👨‍⚕️</h2>
                    <p class="text-muted mb-0">Here's what's happening with your practice today</p>
                </div>
                <div class="d-flex gap-2">
                    <button class="btn btn-outline-primary" onclick="refreshDashboard()">
                        <i class="fas fa-sync-alt me-1"></i>Refresh
                    </button>
                    <a href="{{ route('professional.profile') }}" class="btn btn-primary">
                        <i class="fas fa-user-edit me-1"></i>Update Profile
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Status Alerts -->
    @if(isset($professional) && !$professional->is_verified)
        <div class="alert alert-warning" role="alert">
            <div class="d-flex align-items-center">
                <i class="fas fa-exclamation-triangle fa-2x me-3"></i>
                <div>
                    <h5 class="alert-heading mb-1">Profile Under Review</h5>
                    <p class="mb-0">Your professional profile is currently being reviewed. You'll be notified once verified.</p>
                </div>
            </div>
        </div>
    @endif

    @if(isset($subscription) && $subscription->status !== 'active')
        <div class="alert alert-info" role="alert">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <i class="fas fa-crown fa-2x me-3 text-warning"></i>
                    <div>
                        <h5 class="alert-heading mb-1">Subscription Required</h5>
                        <p class="mb-0">Activate your subscription to start receiving consultation requests.</p>
                    </div>
                </div>
                <a href="{{ route('professional.subscription') }}" class="btn btn-warning">
                    <i class="fas fa-arrow-right me-1"></i>Choose Plan
                </a>
            </div>
        </div>
    @endif

    <!-- Key Performance Metrics -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-primary text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-white-50 mb-1">Total Consultations</h6>
                            <h2 class="mb-0">{{ $stats['total_consultations'] ?? 0 }}</h2>
                            <small class="text-white-50">
                                @if(($stats['consultations_growth'] ?? 0) > 0)
                                    <i class="fas fa-arrow-up me-1"></i>+{{ $stats['consultations_growth'] }}%
                                @else
                                    <i class="fas fa-arrow-down me-1"></i>{{ $stats['consultations_growth'] }}%
                                @endif
                                vs last month
                            </small>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-calendar-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-success text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-white-50 mb-1">Total Earnings</h6>
                            <h2 class="mb-0">₹{{ number_format($stats['total_earnings'] ?? 0) }}</h2>
                            <small class="text-white-50">
                                ₹{{ number_format($stats['earnings_this_month'] ?? 0) }} this month
                            </small>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-rupee-sign fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-warning text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-white-50 mb-1">Average Rating</h6>
                            <h2 class="mb-0">{{ number_format($stats['average_rating'] ?? 0, 1) }}</h2>
                            <div class="star-rating">
                                @for($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star {{ $i <= round($stats['average_rating'] ?? 0) ? 'text-white' : 'text-white-50' }}"></i>
                                @endfor
                            </div>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-star fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-info text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-white-50 mb-1">Pending Reviews</h6>
                            <h2 class="mb-0">{{ $stats['pending_reviews'] ?? 0 }}</h2>
                            <small class="text-white-50">
                                From completed consultations
                            </small>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-comment-dots fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Main Content Area -->
        <div class="col-lg-8">
            <!-- Upcoming Consultations -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-clock me-2"></i>
                        Upcoming Consultations
                    </h5>
                    <a href="{{ route('professional.consultations') }}" class="btn btn-outline-primary btn-sm">
                        View All
                    </a>
                </div>
                <div class="card-body p-0">
                    @if(isset($upcomingConsultations) && count($upcomingConsultations) > 0)
                        <div class="list-group list-group-flush">
                            @foreach($upcomingConsultations as $consultation)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                            <div class="consultation-time me-3 text-center">
                                                <div class="fs-5 fw-bold text-primary">{{ $consultation->scheduled_at->format('d') }}</div>
                                                <small class="text-muted">{{ $consultation->scheduled_at->format('M') }}</small>
                                            </div>
                                            <div>
                                                <h6 class="mb-1">{{ $consultation->client->user->name }}</h6>
                                                <p class="mb-1 text-muted">
                                                    <i class="fas fa-clock me-1"></i>
                                                    {{ $consultation->scheduled_at->format('h:i A') }} • 
                                                    {{ $consultation->duration }} minutes
                                                </p>
                                                <small class="badge bg-{{ $consultation->consultation_type === 'video' ? 'primary' : 'success' }}">
                                                    {{ ucfirst($consultation->consultation_type) }}
                                                </small>
                                            </div>
                                        </div>
                                        <div class="consultation-actions">
                                            @if($consultation->scheduled_at <= now()->addMinutes(15))
                                                <a href="{{ route('consultation.meeting', $consultation) }}" class="btn btn-success btn-sm">
                                                    <i class="fas fa-video me-1"></i>Join
                                                </a>
                                            @else
                                                <span class="text-muted small">
                                                    Starts {{ $consultation->scheduled_at->diffForHumans() }}
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-calendar fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No upcoming consultations</h5>
                            <p class="text-muted">Your scheduled consultations will appear here.</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Recent Reviews -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-star me-2"></i>
                        Recent Reviews
                    </h5>
                    <a href="{{ route('review.received') }}" class="btn btn-outline-primary btn-sm">
                        View All
                    </a>
                </div>
                <div class="card-body p-0">
                    @if(isset($recentReviews) && count($recentReviews) > 0)
                        <div class="list-group list-group-flush">
                            @foreach($recentReviews as $review)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex align-items-start">
                                            <div class="me-3">
                                                <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                                     style="width: 40px; height: 40px;">
                                                    <span class="text-white">
                                                        {{ $review->is_anonymous ? 'A' : substr($review->reviewer->name, 0, 1) }}
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="flex-fill">
                                                <div class="d-flex align-items-center mb-1">
                                                    <h6 class="mb-0 me-2">
                                                        {{ $review->is_anonymous ? 'Anonymous Client' : $review->reviewer->name }}
                                                    </h6>
                                                    <div class="star-rating">
                                                        @for($i = 1; $i <= 5; $i++)
                                                            <i class="fas fa-star {{ $i <= $review->rating ? 'text-warning' : 'text-light' }} small"></i>
                                                        @endfor
                                                    </div>
                                                </div>
                                                <p class="mb-1 text-muted">{{ Str::limit($review->comment, 100) }}</p>
                                                <small class="text-muted">{{ $review->created_at->diffForHumans() }}</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-comment-dots fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No reviews yet</h5>
                            <p class="text-muted">Client reviews will appear here after consultations.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Sidebar -->
        <div class="col-lg-4">
            <!-- Profile Completion -->
            @if(isset($profileCompletion))
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Profile Completion</h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <span>{{ $profileCompletion['percentage'] }}% Complete</span>
                        <small class="text-muted">{{ $profileCompletion['completed'] }}/{{ $profileCompletion['total'] }}</small>
                    </div>
                    <div class="progress mb-3" style="height: 10px;">
                        <div class="progress-bar bg-success" style="width: {{ $profileCompletion['percentage'] }}%"></div>
                    </div>
                    @if(count($profileCompletion['missing']) > 0)
                        <small class="text-muted">Missing: {{ implode(', ', $profileCompletion['missing']) }}</small>
                    @else
                        <small class="text-success">
                            <i class="fas fa-check-circle me-1"></i>Profile complete!
                        </small>
                    @endif
                </div>
            </div>
            @endif

            <!-- Subscription Status -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Subscription Status</h6>
                </div>
                <div class="card-body">
                    @if(isset($subscription) && $subscription->status === 'active')
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <div>
                                <h5 class="mb-0 text-{{ $subscription->subscriptionPlan->name === 'Silver' ? 'secondary' : ($subscription->subscriptionPlan->name === 'Gold' ? 'warning' : 'dark') }}">
                                    {{ $subscription->subscriptionPlan->name }} Plan
                                </h5>
                                <small class="text-muted">{{ $subscription->subscriptionPlan->commission_rate }}% commission rate</small>
                            </div>
                            <span class="badge bg-success">Active</span>
                        </div>
                        
                        <div class="mb-2">
                            <small class="text-muted">Next billing: {{ $subscription->next_billing_date->format('M d, Y') }}</small>
                        </div>
                        
                        <div class="progress mb-3" style="height: 6px;">
                            @php
                                $daysLeft = $subscription->next_billing_date->diffInDays(now());
                                $totalDays = 30; // Assuming monthly billing
                                $percentage = max(0, (($totalDays - $daysLeft) / $totalDays) * 100);
                            @endphp
                            <div class="progress-bar" style="width: {{ $percentage }}%"></div>
                        </div>
                        
                        <div class="d-grid">
                            <a href="{{ route('professional.subscription') }}" class="btn btn-outline-primary btn-sm">
                                Manage Subscription
                            </a>
                        </div>
                    @else
                        <div class="text-center">
                            <i class="fas fa-crown fa-2x text-warning mb-2"></i>
                            <p class="text-muted mb-3">No active subscription</p>
                            <a href="{{ route('professional.subscription') }}" class="btn btn-warning btn-sm">
                                Choose Plan
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">This Month's Performance</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6 mb-3">
                            <h4 class="text-primary mb-0">{{ $stats['consultations_this_month'] ?? 0 }}</h4>
                            <small class="text-muted">Consultations</small>
                        </div>
                        <div class="col-6 mb-3">
                            <h4 class="text-success mb-0">₹{{ number_format($stats['earnings_this_month'] ?? 0) }}</h4>
                            <small class="text-muted">Earnings</small>
                        </div>
                        <div class="col-6">
                            <h4 class="text-warning mb-0">{{ $stats['reviews_this_month'] ?? 0 }}</h4>
                            <small class="text-muted">New Reviews</small>
                        </div>
                        <div class="col-6">
                            <h4 class="text-info mb-0">{{ $stats['response_time'] ?? 'N/A' }}</h4>
                            <small class="text-muted">Avg Response</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.consultation-time {
    min-width: 60px;
}

.star-rating {
    font-size: 0.875rem;
}

.card {
    transition: transform 0.2s;
}

.card:hover {
    transform: translateY(-2px);
}

.progress {
    border-radius: 10px;
}

.bg-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important; }
.bg-success { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%) !important; }
.bg-warning { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%) !important; }
.bg-info { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%) !important; }

@media (max-width: 768px) {
    .consultation-actions {
        margin-top: 10px;
    }
}
</style>
@endpush

@push('scripts')
<script>
function refreshDashboard() {
    window.location.reload();
}

// Auto-refresh every 5 minutes
setInterval(function() {
    // You could make an AJAX call here to update specific sections
    console.log('Dashboard refresh check...');
}, 300000);
</script>
@endpush
@endsection