@extends('layouts.auth')

@section('content')
<div class="auth-header">
    <h1>Welcome Back</h1>
    <p>Sign in to your Medex account</p>
</div>

@if ($errors->any())
    <div class="error-messages">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

@if (session('success'))
    <div class="success-message">
        {{ session('success') }}
    </div>
@endif

<form method="POST" action="{{ route('login') }}">
    @csrf
    
    <div class="form-group">
        <label class="form-label" for="email">Email Address</label>
        <input id="email" class="form-input" type="email" name="email" value="{{ old('email') }}" required autofocus>
    </div>
    
    <div class="form-group">
        <label class="form-label" for="password">Password</label>
        <input id="password" class="form-input" type="password" name="password" required>
    </div>
    
    <div class="form-group">
        <label style="display: flex; align-items: center; gap: 0.5rem;">
            <input type="checkbox" name="remember" {{ old('remember') ? 'checked' : '' }}>
            <span style="font-size: 0.9rem;">Remember me</span>
        </label>
    </div>
    
    <div class="form-group">
        <button class="btn btn-primary" type="submit">Sign In</button>
    </div>
</form>

<div class="auth-links">
    <p>Don't have an account? <a href="{{ route('register') }}">Create one</a></p>
    {{-- <p><a href="#">Forgot your password?</a></p> --}}
</div>
@endsection