@extends('layouts.app')

@section('title', 'Manage Subscription Plans')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Manage Subscription Plans</h5>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPlanModal">
                        <i class="fas fa-plus"></i> Add New Plan
                    </button>
                </div>
                <div class="card-body">
                    <!-- Subscription Plans Table -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Plan Name</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>Commission</th>
                                    <th>Features</th>
                                    <th>Premium</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($subscriptionPlans as $plan)
                                <tr>
                                    <td>{{ $plan->id }}</td>
                                    <td><strong>{{ $plan->name }}</strong></td>
                                    <td>
                                        <div class="text-truncate" style="max-width: 200px;" title="{{ $plan->description }}">
                                            {{ $plan->description }}
                                        </div>
                                    </td>
                                    <td>
                                        <strong class="text-primary">₹{{ number_format($plan->monthly_price ?? 0, 2) }}</strong>
                                        @if($plan->yearly_price)
                                            <br><small class="text-muted">₹{{ number_format($plan->yearly_price, 2) }}/year</small>
                                        @endif
                                    </td>
                                    <td>{{ $plan->commission_percentage ?? 10 }}%</td>
                                    <td>
                                        @if($plan->features)
                                            <ul class="list-unstyled mb-0">
                                                @foreach($plan->features as $feature)
                                                    <li><small>• {{ $feature }}</small></li>
                                                @endforeach
                                            </ul>
                                        @else
                                            <span class="text-muted">No features listed</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column gap-1">
                                            @if($plan->priority_listing)
                                                <span class="badge bg-info">Priority</span>
                                            @endif
                                            @if($plan->featured_profile)
                                                <span class="badge bg-warning">Featured</span>
                                            @endif
                                            @if($plan->dedicated_support)
                                                <span class="badge bg-success">Support</span>
                                            @endif
                                            @if($plan->max_consultations_per_month)
                                                <small class="text-muted">{{ $plan->max_consultations_per_month }} consults/month</small>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $plan->is_active ? 'success' : 'secondary' }}">
                                            {{ $plan->is_active ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editPlanModal{{ $plan->id }}">
                                                Edit
                                            </button>
                                            <form action="{{ route('admin.subscription-plans.destroy', $plan) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger" 
                                                        onclick="return confirm('Are you sure you want to delete this plan?')">
                                                    Delete
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-credit-card fa-3x mb-3"></i>
                                            <p>No subscription plans found.</p>
                                            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPlanModal">
                                                Create First Plan
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Plan Modal -->
<div class="modal fade" id="addPlanModal" tabindex="-1" aria-labelledby="addPlanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPlanModalLabel">Add New Subscription Plan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.subscription-plans.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Plan Name</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="monthly_price" class="form-label">Monthly Price (₹)</label>
                                <input type="number" step="0.01" class="form-control" id="monthly_price" name="monthly_price" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="yearly_price" class="form-label">Yearly Price (₹) - Optional</label>
                                <input type="number" step="0.01" class="form-control" id="yearly_price" name="yearly_price">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="commission_percentage" class="form-label">Commission %</label>
                                <input type="number" step="0.01" max="100" class="form-control" id="commission_percentage" name="commission_percentage" value="10">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="max_consultations_per_month" class="form-label">Max Consultations/Month</label>
                                <input type="number" class="form-control" id="max_consultations_per_month" name="max_consultations_per_month">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="is_active" class="form-label">Status</label>
                                <select class="form-control" id="is_active" name="is_active">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Premium Features -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="priority_listing" name="priority_listing">
                                <label class="form-check-label" for="priority_listing">
                                    Priority Listing
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="featured_profile" name="featured_profile">
                                <label class="form-check-label" for="featured_profile">
                                    Featured Profile
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="dedicated_support" name="dedicated_support">
                                <label class="form-check-label" for="dedicated_support">
                                    Dedicated Support
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="features" class="form-label">Features (one per line)</label>
                        <textarea class="form-control" id="features" name="features" rows="4" placeholder="Enter features, one per line"></textarea>
                        <small class="text-muted">Each line will be treated as a separate feature</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create Plan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Plan Modals -->
@foreach($subscriptionPlans as $plan)
<div class="modal fade" id="editPlanModal{{ $plan->id }}" tabindex="-1" aria-labelledby="editPlanModalLabel{{ $plan->id }}" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPlanModalLabel{{ $plan->id }}">Edit Subscription Plan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.subscription-plans.update', $plan) }}" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_name{{ $plan->id }}" class="form-label">Plan Name</label>
                                <input type="text" class="form-control" id="edit_name{{ $plan->id }}" name="name" value="{{ $plan->name }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_monthly_price{{ $plan->id }}" class="form-label">Monthly Price (₹)</label>
                                <input type="number" step="0.01" class="form-control" id="edit_monthly_price{{ $plan->id }}" name="monthly_price" value="{{ $plan->monthly_price }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_description{{ $plan->id }}" class="form-label">Description</label>
                        <textarea class="form-control" id="edit_description{{ $plan->id }}" name="description" rows="3">{{ $plan->description }}</textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_yearly_price{{ $plan->id }}" class="form-label">Yearly Price (₹) - Optional</label>
                                <input type="number" step="0.01" class="form-control" id="edit_yearly_price{{ $plan->id }}" name="yearly_price" value="{{ $plan->yearly_price }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_commission_percentage{{ $plan->id }}" class="form-label">Commission %</label>
                                <input type="number" step="0.01" max="100" class="form-control" id="edit_commission_percentage{{ $plan->id }}" name="commission_percentage" value="{{ $plan->commission_percentage ?? 10 }}">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_max_consultations{{ $plan->id }}" class="form-label">Max Consultations/Month</label>
                                <input type="number" class="form-control" id="edit_max_consultations{{ $plan->id }}" name="max_consultations_per_month" value="{{ $plan->max_consultations_per_month }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_is_active{{ $plan->id }}" class="form-label">Status</label>
                                <select class="form-control" id="edit_is_active{{ $plan->id }}" name="is_active">
                                    <option value="1" {{ $plan->is_active ? 'selected' : '' }}>Active</option>
                                    <option value="0" {{ !$plan->is_active ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Premium Features -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="edit_priority_listing{{ $plan->id }}" name="priority_listing" {{ $plan->priority_listing ? 'checked' : '' }}>
                                <label class="form-check-label" for="edit_priority_listing{{ $plan->id }}">
                                    Priority Listing
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="edit_featured_profile{{ $plan->id }}" name="featured_profile" {{ $plan->featured_profile ? 'checked' : '' }}>
                                <label class="form-check-label" for="edit_featured_profile{{ $plan->id }}">
                                    Featured Profile
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="edit_dedicated_support{{ $plan->id }}" name="dedicated_support" {{ $plan->dedicated_support ? 'checked' : '' }}>
                                <label class="form-check-label" for="edit_dedicated_support{{ $plan->id }}">
                                    Dedicated Support
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="edit_features{{ $plan->id }}" class="form-label">Features (one per line)</label>
                        <textarea class="form-control" id="edit_features{{ $plan->id }}" name="features" rows="4" placeholder="Enter features, one per line">{{ $plan->features ? implode("\n", $plan->features) : '' }}</textarea>
                        <small class="text-muted">Each line will be treated as a separate feature</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Plan</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach

@if(session('success'))
<div class="alert alert-success alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 1050;" role="alert">
    {{ session('success') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

@if(session('error'))
<div class="alert alert-danger alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 1050;" role="alert">
    {{ session('error') }}
    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
@endif

<script>
// Auto dismiss alerts after 5 seconds
setTimeout(function() {
    $('.alert').fadeOut();
}, 5000);
</script>
@endsection