<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('commissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('consultation_id')->constrained('consultations');
            $table->foreignId('professional_id')->constrained('professionals');
            $table->decimal('consultation_fee', 8, 2);
            $table->integer('commission_percentage');
            $table->decimal('platform_commission', 8, 2);
            $table->decimal('professional_earning', 8, 2);
            $table->decimal('platform_fee', 8, 2)->default(0);
            $table->decimal('gst_amount', 8, 2)->default(0);
            $table->enum('status', ['pending', 'completed', 'disputed']);
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('commissions');
    }
};
