<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('consultations', function (Blueprint $table) {
            $table->id();
            $table->string('consultation_id')->unique(); // CON-YYYYMMDD-XXXX
            $table->foreignId('client_id')->constrained('clients');
            $table->foreignId('professional_id')->constrained('professionals');
            $table->enum('consultation_type', ['video', 'audio', 'chat']);
            $table->datetime('scheduled_at');
            $table->datetime('started_at')->nullable();
            $table->datetime('ended_at')->nullable();
            $table->integer('duration_minutes')->nullable();
            $table->enum('status', ['scheduled', 'in_progress', 'completed', 'cancelled', 'no_show']);
            $table->decimal('consultation_fee', 8, 2);
            $table->decimal('platform_fee', 8, 2);
            $table->decimal('gst_amount', 8, 2);
            $table->decimal('total_amount', 8, 2);
            $table->string('meeting_id')->nullable(); // Jitsi Meet room ID
            $table->string('meeting_url')->nullable();
            $table->text('consultation_notes')->nullable();
            $table->text('client_notes')->nullable();
            $table->json('documents')->nullable(); // Uploaded documents
            $table->string('invoice_number')->nullable();
            $table->timestamp('cancelled_at')->nullable();
            $table->text('cancellation_reason')->nullable();
            $table->foreignId('cancelled_by')->nullable()->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('consultations');
    }
};
