<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('professionals', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->enum('profession_type', ['advocate', 'chartered_accountant', 'company_secretary', 'cost_management_accountant']);
            $table->string('license_number')->unique();
            $table->string('membership_id')->nullable();
            $table->string('registration_body')->nullable(); // Bar Council, ICAI, etc.
            $table->date('license_expiry')->nullable();
            $table->json('specializations')->nullable(); // Array of specializations
            $table->integer('experience_years')->default(0);
            $table->decimal('consultation_fee', 8, 2)->default(0.00);
            $table->json('availability')->nullable(); // Working hours, days
            $table->string('office_address')->nullable();
            $table->string('city');
            $table->string('state');
            $table->string('pincode', 6);
            $table->json('documents')->nullable(); // License, certificates
            $table->enum('verification_status', ['pending', 'verified', 'rejected'])->default('pending');
            $table->timestamp('verified_at')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users');
            $table->text('rejection_reason')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->decimal('rating', 3, 2)->default(0.00);
            $table->integer('total_consultations')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('professionals');
    }
};
