<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable, SoftDeletes, HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'user_type',
        'status',
        'profile_image',
        'bio',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'deleted_at' => 'datetime',
        ];
    }

    /**
     * Check if user is an admin
     */
    public function isAdmin(): bool
    {
        return $this->user_type === 'admin';
    }

    /**
     * Check if user is a professional
     */
    public function isProfessional(): bool
    {
        return $this->user_type === 'professional';
    }

    /**
     * Check if user is a client
     */
    public function isClient(): bool
    {
        return $this->user_type === 'client';
    }

    /**
     * Get the professional profile if user is a professional
     */
    public function professional()
    {
        return $this->hasOne(Professional::class);
    }

    /**
     * Get the client profile if user is a client
     */
    public function client()
    {
        return $this->hasOne(Client::class);
    }

    /**
     * Get user's consultations as a client
     */
    public function clientConsultations()
    {
        return $this->hasManyThrough(Consultation::class, Client::class, 'user_id', 'client_id');
    }

    /**
     * Get user's consultations as a professional
     */
    public function professionalConsultations()
    {
        return $this->hasManyThrough(Consultation::class, Professional::class, 'user_id', 'professional_id');
    }

    /**
     * Get reviews given by this user
     */
    public function reviewsGiven()
    {
        return $this->hasMany(Review::class, 'from_user_id');
    }

    /**
     * Get reviews received by this user
     */
    public function reviewsReceived()
    {
        return $this->hasMany(Review::class, 'to_user_id');
    }
}
